<?php

namespace YOOtheme;

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;
use Joomla\String\StringHelper;

/** @var \Joomla\Component\Finder\Site\View\Search\HtmlView $this */

$view = app(View::class);

// Article template
$article = function ($result) use ($view) {

    $article = [

        // Article
        'article' => $result,
        'link' => $result->route,

        // Params
        'params' => [
            'show_title' => true,
            'link_titles' => true,
        ],

    ];

    if ($this->params->get('show_description', 1)) {

        // Calculate number of characters to display around the result
        $term_length = StringHelper::strlen($this->query->input);
        $desc_length = $this->params->get('description_length', 255);
        $pad_length = $term_length < $desc_length ? floor(($desc_length - $term_length) / 2) : 0;

        // Find the position of the search term
        $pos = $term_length ? StringHelper::strpos(StringHelper::strtolower($result->description), StringHelper::strtolower($this->query->input)) : false;

        // Find a potential start point
        $start = ($pos && $pos > $pad_length) ? $pos - $pad_length : 0;

        // Find a space between $start and $pos, start right after it.
        $space = StringHelper::strpos($result->description, ' ', $start > 0 ? $start - 1 : 0);
        $start = ($space && $space < $pos) ? $space + 1 : $start;

        $article['content'] = HTMLHelper::_('string.truncate', StringHelper::substr($result->description, $start), $desc_length, true);
    }

    return $view('~theme/templates/article{-search,}', $article);
};

?>
<?php // Display the suggested search if it is different from the current search. ?>
<?php if (($this->suggested && $this->params->get('show_suggested_query', 1)) || ($this->explained && $this->params->get('show_explained_query', 1))) : ?>
<p>
    <?php // Display the suggested search query. ?>
    <?php if ($this->suggested && $this->params->get('show_suggested_query', 1)) : ?>
        <?php // Replace the base query string with the suggested query string. ?>
        <?php $uri = Uri::getInstance($this->query->toUri()) ?>
        <?php $uri->setVar('q', $this->suggested) ?>

        <?php // Compile the suggested query link. ?>
        <?php $linkUrl = Route::_($uri->toString(['path', 'query'])) ?>
        <?php $link = '<a href="' . $linkUrl . '">' . $this->escape($this->suggested) . '</a>' ?>

        <?= Text::sprintf('COM_FINDER_SEARCH_SIMILAR', $link) ?>

    <?php // Display the explained search query. ?>
    <?php elseif ($this->explained && $this->params->get('show_explained_query', 1)) : ?>
        <?= $this->explained ?>
    <?php endif ?>
</p>
<?php endif ?>

<?php // Display the 'no results' message and exit the template. ?>
<?php if ($this->total == 0) : ?>
    <h1 class="uk-h2"><?= Text::_('COM_FINDER_SEARCH_NO_RESULTS_HEADING') ?></h1>
    <?php $multilang = Factory::getApplication()->getLanguageFilter() ? '_MULTILANG' : '' ?>
    <p><?= Text::sprintf('COM_FINDER_SEARCH_NO_RESULTS_BODY' . $multilang, $this->escape($this->query->input)) ?></p>
    <?php // Exit this template. ?>
<?php else : ?>

<?php
// Activate the highlighter if enabled.
if (!empty($this->query->highlight) && $this->params->get('highlight_terms', 1)) {
    $this->getDocument()->getWebAssetManager()->useScript('highlight');
    $this->getDocument()->addScriptOptions(
        'highlight',
        [[
            'class' => 'js-highlight',
            'highLight' => $this->query->highlight,
        ]]
    );
}
?>

<?php // Display the 'Sort By' drop-down. ?>
<?php if ($this->params->get('show_sort_order', 0) && !empty($this->sortOrderFields) && !empty($this->results)) : ?>
    <?= $this->loadTemplate('sorting') ?>
<?php endif ?>

<?php // Display a list of results ?>
<div class="js-highlight">
    <?php foreach ($this->results as $result) : ?>
        <?= $article($result) ?>
    <?php endforeach ?>
</div>

<?= $this->pagination->getPagesLinks() ?>
<?php endif ?>
