<?php

namespace YOOtheme\Builder\Joomla\Source\Listener;

use Joomla\CMS\Application\CMSApplication;
use Joomla\CMS\MVC\View\HtmlView;
use Joomla\Event\Event;
use YOOtheme\Config;
use YOOtheme\Theme\Joomla\LoadTemplateEvent;
use YOOtheme\Theme\Joomla\ThemeLoader;

class LoadNotFound
{
    public Config $config;
    public CMSApplication $joomla;

    public function __construct(Config $config, CMSApplication $joomla)
    {
        $this->config = $config;
        $this->joomla = $joomla;
    }

    /**
     * @param Event $event
     */
    public function handle($event): void
    {
        [$result] = $event->getArguments();

        if (!$this->config->get('theme.template')) {
            ThemeLoader::initTheme();
        }

        $loadTemplateEvent = new LoadTemplateEvent('onLoadTemplate', [
            'view' => new HtmlView(['name' => '404', 'base_path' => '', 'template_path' => '']),
            'context' => '404',
            'tpl' => null,
        ]);

        $this->joomla->getDispatcher()->dispatch($loadTemplateEvent->getName(), $loadTemplateEvent);

        if ($this->config->get('app.isCustomizer')) {
            $result['customizer'] = sprintf(
                '<script id="customizer-data">window.yootheme ||= {}; yootheme.customizer = JSON.parse(atob("%s"));</script>',
                base64_encode(json_encode($this->config->get('customizer'))),
            );
        }

        if ($output = $loadTemplateEvent->getOutput()) {
            $result['404'] = $output;
        }
    }
}
