<?php

// Override default settings
$element['panel_style'] = $props['panel_style'] ?: $element['panel_style'];

// Resets
if ($props['icon'] && !($props['image'] || $props['video'])) { $element['panel_image_no_padding'] = ''; }

if (!($element['panel_style'] || (!$element['panel_style'] && ($props['image'] || $props['video']) && $element['image_align'] != 'between'))) {
    $element['panel_padding'] = '';
}

// Override default settings
$element['image_text_color'] = $props['image_text_color'] ?: $element['image_text_color'];

// New logic shortcuts
$element['flex_column_align'] = '';
$element['flex_column_align_fallback'] = '';
if ($element['panel_expand']) {
    $horizontal = ['left', 'center', 'right'];
    $vertical = ['top', 'middle', 'bottom'];
    $element['flex_column_align'] = str_replace($horizontal, $vertical, $element['text_align'] ?? '');
    $element['flex_column_align_fallback'] = str_replace($horizontal, $vertical, $element['text_align_fallback'] ?? '');

    // `uk-flex-top` prevents child inline elements from taking the whole width, needed for floating shadow + hover image
    if (!$element['panel_style']) {
        if ($element['text_align'] && $element['text_align_breakpoint'] && !$element['text_align_fallback']) {
            $element['flex_column_align_fallback'] = 'top';
        } elseif (!$element['text_align']) {
            $element['flex_column_align'] = 'top';
        }
    }
}

// Image
$props['image'] = $this->render("{$__dir}/template-media", compact('props', 'element'));

// Panel/Card/Tile
$el = $this->el($props['item_element'] ?: 'div', [

    'class' => [
        'el-item',

        // Can't use `uk-grid-item-match` because `flex-wrap: warp` creates a multi-line flex container which doesn't shrink the child height if its content is larger
        'uk-width-1-1 {@panel_match}',
        'uk-flex uk-flex-column {@panel_match} {@panel_link}' => $props['link'],

        'tm-video-toggle {@video_autoplay: hover}' => $props['video'] || $props['hover_video'],
    ],

]);

// Link Container
$link_container = $props['link'] && $element['panel_link'] ? $this->el('a', [

    'class' => [
        'uk-tile-hover {@panel_style: tile-.*} {@panel_link_hover}',
        'uk-card-hover {@panel_style: card-(default|primary|secondary|overlay)} {@panel_link_hover}',
        'uk-flex-1 {@panel_match}',
        'uk-display-block {@!panel_match}',
    ],

]) : null;

($link_container ?: $el)->attr([

    'class' => [
        'uk-panel [uk-{panel_style: tile-.*}] {@panel_style: |tile-.*}',
        'uk-card uk-{panel_style: card-.*} [uk-card-{!panel_padding: |default}]',
        'uk-transition-toggle {@panel_link}' => $props['image'] && ($element['image_transition'] || $props['hover_image'] || $props['hover_video']),
        'uk-flex uk-flex-column {@panel_expand}',
        // Image not wrapped in card media container or grid
        'uk-flex-{flex_column_align}[@{text_align_breakpoint} [uk-flex-{flex_column_align_fallback}]] {@panel_expand}' => !($element['panel_style'] && str_starts_with($element['panel_style'], 'card-') && $props['image'] && $element['panel_image_no_padding'] && $element['image_align'] != 'between') && !in_array($element['image_align'], ['left', 'right']),
    ],

]);

// Padding
$content_container = '';
if ($element['panel_padding'] && $props['image'] && (!$element['panel_style'] || $element['panel_image_no_padding']) && $element['image_align'] != 'between') {

    $content_container = $this->el('div', [
        'class' => [
            'uk-flex-1 uk-flex uk-flex-column {@content_expand}',
            // Image not wrapped in card media container or grid
            'uk-width-1-1 {@flex_column_align} {@panel_expand}' => !($element['panel_style'] && str_starts_with($element['panel_style'], 'card-') && $props['image'] && $element['panel_image_no_padding'] && $element['image_align'] != 'between') && !in_array($element['image_align'], ['left', 'right']),
        ],
    ]);

}

($content_container ?: $link_container ?: $el)->attr('class', [
    'uk-padding[-{!panel_padding: default}] {@panel_style: |tile-.*} {@panel_padding}',
    'uk-card-body {@panel_style: card-.*} {@panel_padding}',
]);

// Image align
$grid = '';
$cell_image = '';
$cell_content = '';
if ($props['image'] && in_array($element['image_align'], ['left', 'right'])) {

    $grid = $this->el('div', [

        'class' => [
            $element['panel_style'] && $element['panel_image_no_padding']
                ? 'uk-grid-collapse'
                : ($element['image_grid_column_gap'] == $element['image_grid_row_gap']
                    ? 'uk-grid-{image_grid_column_gap}'
                    : '[uk-grid-column-{image_grid_column_gap}] [uk-grid-row-{image_grid_row_gap}]'),
            // Center vertically
            'uk-flex-middle {@image_vertical_align} {@!panel_expand}',
            // Expand
            'uk-flex-1 {@panel_expand}',
            'uk-flex-column {@panel_expand} uk-flex-row@{image_grid_breakpoint}',
        ],

        'uk-grid' => true,
    ]);

    $cell_image = $this->el('div', [

        'class' => [
            'uk-width-{image_grid_width}[@{image_grid_breakpoint}]',
            // Order
            'uk-flex-last[@{image_grid_breakpoint}] {@image_align: right}',
            // Center vertically and keep text align
            'uk-flex uk-flex-middle[@{image_grid_breakpoint}] uk-flex-{text_align} {@image_vertical_align} {@content_expand} {@!image_expand}',
            'uk-flex-{text_align}[@{text_align_breakpoint} [uk-flex-{text_align_fallback}]] {@content_expand} {@!image_expand}',
            // Expand, also when stacking
            'uk-flex uk-flex-column {@image_expand} [uk-flex-1 uk-flex-initial@{image_grid_breakpoint}]',
            'uk-flex-{flex_column_align}[@{text_align_breakpoint} [uk-flex-{flex_column_align_fallback}]] {@image_expand}',
        ],

    ]);

    $cell_content = $this->el('div', [

        'class' => [
            'uk-width-expand',
            // Center vertically
            'uk-flex uk-flex-column uk-flex-center[@{image_grid_breakpoint}] {@image_vertical_align} {@image_expand} {@!content_expand}',
            // Expand, also when stacking but only for `content`
            'uk-flex uk-flex-column {@content_expand}',
            'uk-flex-1 {@image_grid_breakpoint} {@content_expand} {@!image_expand}',
            'uk-flex-1[@{image_grid_breakpoint} uk-flex-none] {@content_expand} {@image_expand}',
            'uk-flex-none uk-flex-1@{image_grid_breakpoint} {@image_expand} {@!content_expand}',
        ],

    ]);

}

($content_container ?: $cell_content ?: $link_container ?: $el)->attr('class', [
    'uk-margin-remove-first-child',
]);

// Link
$link = include "{$__dir}/template-link.php";

// Card Media (Needs to be after link)
if ($element['panel_style'] && str_starts_with($element['panel_style'], 'card-') && $props['image'] && $element['panel_image_no_padding'] && $element['image_align'] != 'between') {

    $props['image'] = $this->el('div', [
        'class' => [
            'uk-card-media-{image_align}',
            'uk-flex-1 uk-flex uk-flex-column {@image_expand}',
            'uk-flex-{flex_column_align}[@{text_align_breakpoint} [uk-flex-{flex_column_align_fallback}]] {@image_expand} {@!image_align: left|right}',
        ],

        'uk-toggle' => [
            'cls: uk-card-media-{image_align} uk-card-media-top; mode: media; media: @{image_grid_breakpoint} {@image_align: left|right}',
        ]
    ], $props['image'])->render($element);

}

?>

<?= $el($element, $attrs) ?>

    <?php if ($link_container) : ?>
    <?= $link_container($element) ?>
    <?php endif ?>

        <?php if ($grid) : ?>
        <?= $grid($element) ?>
        <?php endif ?>

            <?php if ($cell_image) : ?>
            <?= $cell_image($element) ?>
            <?php endif ?>

                <?php if (in_array($element['image_align'], ['left', 'right'])) : ?>
                <?= $props['image'] ?>
                <?php endif ?>

            <?php if ($cell_image) : ?>
            <?= $cell_image->end() ?>
            <?php endif ?>

            <?php if ($cell_content) : ?>
            <?= $cell_content($element) ?>
            <?php endif ?>

                <?php if ($element['image_align'] == 'top') : ?>
                <?= $props['image'] ?>
                <?php endif ?>

                <?php if ($content_container) : ?>
                <?= $content_container($element) ?>
                <?php endif ?>

                    <?= $this->render("{$__dir}/template-content", compact('props', 'link')) ?>

                <?php if ($content_container) : ?>
                <?= $content_container->end() ?>
                <?php endif ?>

                <?php if ($element['image_align'] == 'bottom') : ?>
                <?= $props['image'] ?>
                <?php endif ?>

            <?php if ($cell_content) : ?>
            <?= $cell_content->end() ?>
            <?php endif ?>

        <?php if ($grid) : ?>
        <?= $grid->end() ?>
        <?php endif ?>

    <?php if ($link_container) : ?>
    <?= $link_container->end() ?>
    <?php endif ?>

<?= $el->end() ?>
