<?php

namespace YOOtheme;

return [
    'name' => 'switcher_item',
    'title' => 'Item',
    'width' => 500,
    'placeholder' => [
        'props' => [
            'title' => 'Title',
            'meta' => '',
            'content' =>
                'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.',
            'image' => '',
            'label' => '',
            'thumbnail' => '',
        ],
    ],
    'templates' => [
        'render' => __DIR__ . '/templates/template.php',
        'content' => __DIR__ . '/templates/content.php',
    ],
    'transforms' => [
        'render' => function ($node, $params) {
            // Display
            foreach (['meta', 'content', 'image', 'link', 'label', 'thumbnail'] as $key) {
                if (!$params['parent']->props["show_{$key}"]) {
                    $node->props[$key] = '';
                }
            }

            // Don't render element if content fields are empty
            // First part checks for title, second part checks for content
            return ($node->props['title'] != '' ||
                $node->props['label'] != '' ||
                $node->props['thumbnail'] ||
                $node->props['image']) &&
                (($node->props['title'] != '' && $params['parent']->props['show_title']) ||
                    $node->props['meta'] != '' ||
                    $node->props['content'] != '' ||
                    $node->props['image']);
        },
    ],
    'fields' => [
        'title' => [
            'label' => 'Title',
            'source' => true,
        ],
        'meta' => [
            'label' => 'Meta',
            'source' => true,
        ],
        'content' => [
            'label' => 'Content',
            'type' => 'editor',
            'source' => true,
        ],
        'image' => '${builder.image}',
        'image_alt' => '${builder.image_alt}',
        'link' => '${builder.link}',
        'link_text' => [
            'label' => 'Link Text',
            'description' => 'Set a different link text for this item.',
            'source' => true,
            'enable' => 'link',
        ],
        'label' => [
            'label' => 'Navigation Label',
            'source' => true,
        ],
        'thumbnail' => [
            'label' => 'Navigation Thumbnail',
            'description' => 'This is only used, if the thumbnail navigation is set.',
            'type' => 'image',
            'source' => true,
        ],
        'item_element' => '${builder.html_element_item}',
        'image_focal_point' => [
            'label' => 'Focal Point',
            'description' => 'Set a focal point to control cropping.',
            'type' => 'select',
            'options' => [
                'Top Left' => 'top-left',
                'Top Center' => 'top-center',
                'Top Right' => 'top-right',
                'Center Left' => 'center-left',
                'Center Center' => '',
                'Center Right' => 'center-right',
                'Bottom Left' => 'bottom-left',
                'Bottom Center' => 'bottom-center',
                'Bottom Right' => 'bottom-right',
            ],
            'source' => true,
            'enable' => 'image',
        ],
        'thumbnail_focal_point' => [
            'label' => 'Focal Point',
            'description' => 'Set a focal point to control cropping.',
            'type' => 'select',
            'options' => [
                'Top Left' => 'top-left',
                'Top Center' => 'top-center',
                'Top Right' => 'top-right',
                'Center Left' => 'center-left',
                'Center Center' => '',
                'Center Right' => 'center-right',
                'Bottom Left' => 'bottom-left',
                'Bottom Center' => 'bottom-center',
                'Bottom Right' => 'bottom-right',
            ],
            'source' => true,
            'enable' => 'thumbnail',
        ],
        'name' => '${builder.nameItem}',
        'status' => '${builder.statusItem}',
        'source' => '${builder.source}',
        'id' => '${builder.id}',
        'class' => '${builder.cls}',
        'attributes' => '${builder.attrs}',
    ],
    'fieldset' => [
        'default' => [
            'type' => 'tabs',
            'fields' => [
                [
                    'title' => 'Content',
                    'fields' => [
                        'title',
                        'meta',
                        'content',
                        'image',
                        'image_alt',
                        'link',
                        'link_text',
                        'label',
                        'thumbnail',
                    ],
                ],
                [
                    'title' => 'Settings',
                    'fields' => [
                        [
                            'label' => 'Item',
                            'type' => 'group',
                            'divider' => true,
                            'fields' => ['item_element'],
                        ],
                        [
                            'label' => 'Image',
                            'type' => 'group',
                            'divider' => true,
                            'fields' => ['image_focal_point'],
                        ],
                        [
                            'label' => 'Thumbnail',
                            'type' => 'group',
                            'fields' => ['thumbnail_focal_point'],
                        ],
                    ],
                ],
                '${builder.advancedItem}',
            ],
        ],
    ],
];
