<?php

namespace YOOtheme\Theme\Joomla\Listener;

use Joomla\CMS\Application\SiteApplication;
use YOOtheme\Config;
use YOOtheme\Event;

class LoadThemeHead
{
    public Config $config;
    public ?SiteApplication $joomla;

    public function __construct(Config $config, ?SiteApplication $joomla)
    {
        $this->config = $config;
        $this->joomla = $joomla;
    }

    public function handle(): void
    {
        if (!$this->isThemeActive()) {
            return;
        }

        $this->config->add('~theme', [
            'direction' => $this->joomla->getDocument()->getDirection(),
            'page_class' => $this->joomla->getParams()->get('pageclass_sfx'),
        ]);

        Event::emit('theme.head');
    }

    protected function isThemeActive(): bool
    {
        return isset($this->joomla) &&
            $this->joomla->getInput()->getCmd('tmpl') !== 'component' &&
            $this->joomla->getInput()->getCmd('option') !== 'com_ajax' &&
            $this->config->get('theme.active');
    }
}
